// Copyright 1998 Macromedia, Inc. All rights reserved.

//*************** GLOBAL VARS  *****************

var helpDoc = MM.HELP_behChangeProperty;

function initGlobals() {
  var x,y;

  TAGTYPES = new Array("LAYER","DIV","SPAN","IMG","FORM","INPUT/CHECKBOX","INPUT/RADIO",
                         "INPUT/TEXT","TEXTAREA","INPUT/PASSWORD","SELECT");
  MENUMAXLEN = 0;

  PROP = new Array();
  //Create array for each tagname, which we can access with PROP[browser][tag]
  for (x=0; x<BROWSERS.length; x++) {
    PROP[x] = new Array();
    for (y=0; y<TAGNAMES.length; y++) PROP[x][y] = new Array();
  }

  //This table provides a dynamic way add properties to the picklist. There are are 4
  //groups, one for each browser/version (see BROWSERS array above).
  //You can add writeable properties, comma-separated, between the first pair of quotes.
  //To add another tag, extend the TAGNAMES and TAGTYPES arrays above, then add another
  //array element to each group below.

  //Netscape 3 Writable Properties
  PROP[0][ 0] = "".split(",");//layer
  PROP[0][ 1] = "".split(",");//div
  PROP[0][ 2] = "".split(",");//span
  PROP[0][ 3] = "src".split(",");//image
  PROP[0][ 4] = "action".split(",");//form
  PROP[0][ 5] = "checked".split(",");//checkbox
  PROP[0][ 6] = "checked".split(",");//radio
  PROP[0][ 7] = "value".split(",");//text
  PROP[0][ 8] = "value".split(",");//textarea
  PROP[0][ 9] = "value".split(",");//password
  PROP[0][10] = "selectedIndex".split(",");//select

  //IE 3 Writable Properties
  PROP[1][ 0] = "".split(",");//layer
  PROP[1][ 1] = "".split(",");//div
  PROP[1][ 2] = "".split(",");//span
  PROP[1][ 3] = "".split(",");//image
  PROP[1][ 4] = "action".split(",");//form
  PROP[1][ 5] = "checked".split(",");//checkbox
  PROP[1][ 6] = "checked".split(",");//radio
  PROP[1][ 7] = "value".split(",");//text
  PROP[1][ 8] = "value".split(",");//textarea
  PROP[1][ 9] = "value".split(",");//password
  PROP[1][10] = "selectedIndex".split(",");//select

  //Netscape 4 Writable Properties
  PROP[2][ 0] = "top,left,zIndex,clip,visibility,document.bgColor,document.background".split(",");//layer
  PROP[2][ 1] = "".split(",");//div
  PROP[2][ 2] = "".split(",");//span
  PROP[2][ 3] = "src".split(",");//image
  PROP[2][ 4] = "action".split(",");//form
  PROP[2][ 5] = "checked".split(",");//checkbox
  PROP[2][ 6] = "checked".split(",");//radio
  PROP[2][ 7] = "value".split(",");//text
  PROP[2][ 8] = "value".split(",");//textarea
  PROP[2][ 9] = "value".split(",");//password
  PROP[2][10] = "selectedIndex".split(",");//select

  //IE 4 Writable Properties
  PROP[3][ 0] = ("style.top,style.left,style.width,style.height,style.zIndex,style.clip,style.visibility,"+
                 "style.backgroundColor,style.backgroundImage,style.filter").split(",");//layer
  PROP[3][ 1] = ("style.fontFamily,style.fontStyle,style.fontWeight,style.fontSize,"+
                "style.borderStyle,style.borderWidth,style.borderColor,style.backgroundColor,"+
                "style.backgroundImage,style.filter,innerHTML,innerText").split(",");//div
  PROP[3][ 2] = ("style.fontFamily,style.fontStyle,style.fontWeight,style.fontSize,"+
                "style.borderStyle,style.borderWidth,style.borderColor,style.backgroundColor,"+
                "style.backgroundImage,style.filter,innerHTML,innerText").split(",");//span
  PROP[3][ 3] = "src".split(",");//image
  PROP[3][ 4] = "action".split(",");//form
  PROP[3][ 5] = "checked".split(",");//checkbox
  PROP[3][ 6] = "checked".split(",");//radio
  PROP[3][ 7] = "value".split(",");//text
  PROP[3][ 8] = "value".split(",");//textarea
  PROP[3][ 9] = "value".split(",");//password
  PROP[3][10] = "selectedIndex".split(",");//select
}

var TAGTYPES;
var MENUMAXLEN;
var PROP;
var USENSREFS;



//******************* BEHAVIOR FUNCTION **********************

//Sets a property of an object to a new value.
//Accepts the following arguments:
//  objName  - simple obj name or Javascript object ref for Netscape (ex: document.layers['foo'].document.myImage)
//  x        - ignored (for backward compatibility)
//  theProp  - the property to change (ex: value, style.fontFace)
//  theValue - the new value (ex: sans-serif)
//Also accepts a simple object name ("image1") as the first argument.
//
//Tests for browser, and uses the first object string for NS, the second for IE
//The next test is to prevent errors in < 4.0 browsers if the object's in a layer.
//If the object still exists, and either it's not a style property, or the style prop is okay.

function MM_changeProp(objName,x,theProp,theValue) { //v3.0
  var obj = MM_findObj(objName);
  if (obj && (theProp.indexOf("style.")==-1 || obj.style)) eval("obj."+theProp+"='"+theValue+"'");
}

MM.VERSION_MM_changeProp = 3.0; //define latest version number for behavior inspector

//******************* API **********************


//Can be used with any tag and any event

function canAcceptBehavior(){
  return true;
}



//Returns a Javascript function to be inserted in HTML head with script tags.

function behaviorFunction(){
  return "MM_findObj,MM_changeProp";
}



//Returns fn call to insert in HTML tag <TAG... onEvent='thisFn(arg)'>
//Gets values from the UI and adds them as params to the function call.

function applyBehavior() {
  var menuIndex,theObjNS,theProp="",theValue,theTag;

  //read all values from UI
  menuIndex = document.theForm.menu.selectedIndex; //get index selected
  if (menuIndex != -1 && document.theForm.menu.options[menuIndex].text.indexOf("*")!=0) {
    if (USENSREFS)
      theObjNS   = escQuotes(document.MM_NS_REFS[menuIndex]);
	else
      theObjNS   = escQuotes(document.MM_IE_REFS[menuIndex]);
    theValue = escQuotes(document.theForm.theValue.value);
    menuIndex = document.theForm.typeOfObj.selectedIndex; //get index selected
    theTag   = document.theForm.typeOfObj.options[menuIndex].text;

    if (document.theForm.theRadio[0].checked) { //get property from menu
      theProp = document.theForm.propMenu.options[document.theForm.propMenu.selectedIndex].text;
    } else { //get from textfield
      theProp  = document.theForm.theProp.value;
    }

    if (theObjNS.indexOf(REF_UNNAMED) == 0)  //if unnamed reference
      return MSG_UnnamedObj;
    else {
      theObjNS = getNameFromRef(theObjNS);
  } }

  if (!theProp) {
    return MSG_NoSelection;
  } else {
    updateBehaviorFns("MM_findObj","MM_changeProp");
    return "MM_changeProp('"+theObjNS+"','','"+theProp+"','"+theValue+"','"+theTag+"')"; //fn call w/args
  }
}



//Returns a dummy function call to inform Dreamweaver the type of certain behavior
//call arguments. This information is used by DW to fixup behavior args when the
//document is moved or changed.
//
//It is passed an actual function call string generated by applyBehavior(), which
//may have a variable list of arguments, and this should return a matching mask.
//
//The return values are:
//  URL     : argument could be a file path, which DW will update during Save As...
//  NS4.0ref: arg is an object ref that may be changed by Convert Tables to Layers
//  IE4.0ref: arg is an object ref that may be changed by Convert Tables to Layers
//  other...: argument is ignored (I add a descriptive word for future generations)
//  objName : simple name used by MM_findObj, such as "image1"

function identifyBehaviorArguments(fnCallStr) {
  var argArray, retVal = "";

  argArray = extractArgs(fnCallStr);
  if (argArray.length == 6)
    retVal = (argArray[i+1].indexOf(".")==-1)? "objName,other,other,other,other" : "NS4.0ref,IE4.0ref,other,other,other";
  return retVal;
}



//Given the original function call, this parses out the args and updates
//the UI.

function inspectBehavior(fnCallStr){
  var i,found,numTags,numObjs;
  var theObjNS, theProp, theValue, theTag;
  var argArray = new Array;

  //get previous args
  argArray = extractArgs(fnCallStr);
  if (argArray.length > 5) {
    theObjNS = unescQuotes(argArray[1]);
    theProp = argArray[3];
    theValue = unescQuotes(argArray[4]);
    theTag = argArray[5];

    //select tag in tag list
    found = false;
    numTags = document.theForm.typeOfObj.options.length;
    for (i=0; i<numTags; i++)  //check if theTag is in menu
      if (document.theForm.typeOfObj.options[i].text == theTag) { //if theTag there
        document.theForm.typeOfObj.selectedIndex = i;
        found = true;
        break;
      }
    if (!found) alert(errMsg(MSG_TagNotFound,theTag));
    else {
      loadAllMenus();  //simulate tag being selected

      //select obj in menu
      found = false;
      numObjs = document.MM_NS_REFS.length;
      for (i=0; i<numObjs; i++) { //check if theObjNS is in menu
        if (theObjNS == document.MM_NS_REFS[i] || theObjNS == getNameFromRef(document.MM_NS_REFS[i])) { //if found
          document.theForm.menu.selectedIndex = i;
          found = true;
          break;
      } }
      if (!found) alert(errMsg(MSG_ObjNotFound,theObjNS));
      else {
        document.theForm.theProp.value = theProp;
        selectRadio(1);
        document.theForm.theValue.value = theValue;
      }
    }

  }
}



//***************** LOCAL FUNCTIONS  ******************


//Load the typeOfObj menu with tag names, the browser menu,
//and initialize the object menu.

function initializeUI(){
  initGlobals();
  var listLen=eval(TAGTYPES.length); //get array length

  //load TAGS picklist
  for (var i=0;i<listLen;i++)
    document.theForm.typeOfObj.options[i]=new Option(TAGTYPES[i]); //load menu

  //load browser picklist
  for (i=0;i<BROWSERS.length;i++)
    document.theForm.browserMenu.options[i]=new Option(BROWSERS[i]); //load menu
  document.theForm.browserMenu.selectedIndex = DEFAULT_BROWSER;

  document.theForm.propMenu.options[0]=new Option("");

  document.theForm.menu.options[0]=new Option("*** "+MENUITEM_NoTypeSelected+" **");
  document.theForm.menu.mylength = 1;  //WORKAROUND! create the length property for main menu
  document.theForm.menu.selectedIndex = 0;

  document.theForm.theValue.focus(); //set focus on textbox
  document.theForm.theValue.select(); //set insertion point into textbox
}



//Loads the new objects, and a list of usefule properties.

function loadAllMenus() {
  loadObjectMenu();
  loadPropMenu();
}



//Loads a list of useful properties from the data array PROP.

function loadPropMenu() {
  var tagIndex, brIndex, i;

  //get browser selection from browserMenu
  brIndex = document.theForm.browserMenu.selectedIndex;

  //get tag selection from typeOfObj
  tagIndex = document.theForm.typeOfObj.selectedIndex;

  if (brIndex > -1 && tagIndex > -1) {

    //Can't set menu length, so must erase old values
    for (i=0; i<MENUMAXLEN; i++)
      document.theForm.propMenu.options[i]=new Option("");

    //add each property to list
    for (i=0; i<PROP[brIndex][tagIndex].length; i++)
      document.theForm.propMenu.options[i]=new Option(PROP[brIndex][tagIndex][i]);

    document.theForm.propMenu.selectedIndex = 0;
    MENUMAXLEN = Math.max(MENUMAXLEN,i);
  }
}



//Load the select menu with object references.

function loadObjectMenu() {
  var nameArray = new Array;
  var i,menuLen,tagIndex,tagStr,listLen,niceNameSrcArray;

  //put up a temporary msg while their waiting  (not currently seen)
  document.theForm.menu.options[0]=new Option("*** "+MENUITEM_Searching+" ***"); //temporary msg
  document.theForm.menu.selectedIndex = 0; //reselect the menu item

  //Clear out old menu (WORKAROUND! Must maintain length field)
  menuLen = document.theForm.menu.mylength;  //get previous length
  for (i=1; i<menuLen; i++) document.theForm.menu.options[i]=new Option(""); //clear each item
  menuLen = 0; //menu now "zero" length

  //get list of objects
  tagIndex = document.theForm.typeOfObj.selectedIndex;
  tagStr = document.theForm.typeOfObj.options[tagIndex].text;
  document.MM_NS_REFS = getAllObjectRefs("NS 4.0",tagStr); //store parallel NS refs
  document.MM_IE_REFS = getAllObjectRefs("IE 4.0",tagStr); //store parallel IE refs
  niceNameSrcArray = document.MM_NS_REFS;
  USENSREFS = true;

  //Search for unreferenceable objects. <DIV id="foo"> is IE only, <LAYER> is NS only.
  //if REF_CANNOT found, return empty string, and use IE refs for nice namelist.
  for (i=0; i<document.MM_NS_REFS.length; i++) {
    if (document.MM_IE_REFS[i].indexOf(REF_CANNOT) == 0) {
      document.MM_IE_REFS[i] = ""; //blank it out
    }
    if (document.MM_NS_REFS[i].indexOf(REF_CANNOT) == 0) {
      document.MM_NS_REFS[i] = ""; //blank it out
      niceNameSrcArray = document.MM_IE_REFS; //use the IE list
	  USENSREFS = false;
    }
  }
  nameArray = niceNames(niceNameSrcArray,TAGNAMES[tagIndex]);

  //load menu with object names
  if (nameArray.length == 0) {  //if nothing to display...
    document.theForm.menu.options[0]=new Option("*** "+errMsg(MENUITEM_ItemsNotFnd,tagStr)+" ***"); //clear menu
  } else { //something there, load the menu
    listLen = nameArray.length; //get array length
    for (menuLen=0; menuLen<listLen; menuLen++)
      document.theForm.menu.options[menuLen]=new Option(nameArray[menuLen]); //load menu
  }
  document.theForm.menu.mylength = menuLen;  //WORKAROUND! re-store the length property

  document.theForm.typeOfObj.selectedIndex = tagIndex; //reselect the menu item
}



//Passed a number, selects that radio.

function selectRadio(num) {
  document.theForm.theRadio[0].checked = (num==0)?true:false;
  document.theForm.theRadio[1].checked = (num==1)?true:false;
}
